///////////////////////////////////////////////////////////////////////////////////
//No part of this file can be copied or released without the consent of 
//Avalanche Technology
//										
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
//										
//	Avalanche Technology Inc., Proprietary and Confidential	   *
//										
// 	Release:  3.0    Date 6/7/2023  	
//							
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//  PART DESCRIPTION:
//
//  Technology: 22nm pMTJ STT-MRAM
//  Part:       AS3001316/AS3004316/AS3008316/AS3016316/AS3032316/AS3064316
//
//  Description: 1/4/8/16/32/64 MEGABIT PARALLEL PERSISTENT SRAM MEMORY
//
////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
//  FILE CONTENTS : Testbench
//
////////////////////////////////////////////////////////////////////////////////////

`define DENSITY_1M
//`define DENSITY_4M
//`define DENSITY_8M
//`define DENSITY_16M
//`define DENSITY_32M
//`define DENSITY_64M

`define TIMING_45
//`define TIMING_35

////////////////////////////////////////////////////////////////////////////////////
// MODULE DECLARATION                                                             //
////////////////////////////////////////////////////////////////////////////////////
`timescale 1ns/1ps

`include "ppsram_as30xx316.v"
`include "stimulus.v"

module test;

  wire CE, OE, WE;
  wire [15:0] DQ;
  wire UBn, LBn;
    

  wire [21:0] ADDR;

  ppsram_as30xx316 M0(
    .En(CE),
    .Gn(OE),
    .Wn(WE),
`ifdef DENSITY_1M
    .ADDR(ADDR[15:0]),
`elsif DENSITY_4M
    .ADDR(ADDR[17:0]),
`elsif DENSITY_8M
    .ADDR(ADDR[18:0]),
`elsif DENSITY_16M
    .ADDR(ADDR[19:0]),
`elsif DENSITY_32M
    .ADDR(ADDR[20:0]),
`elsif DENSITY_64M
    .ADDR(ADDR[21:0]),
`else
    .ADDR(ADDR[15:0]),
`endif
    .DQ(DQ),
    .UBn(UBn),
    .LBn(LBn)
    );

  stimulus inst_stim (
    .En(CE),
    .Gn(OE),
    .Wn(WE),
    .ADDR(ADDR),
    .DQ(DQ),
    .UBn(UBn),
    .LBn(LBn)
    );

  initial begin
    $vcdpluson;
    //$shm_open("test.shm");
    //$shm_probe(test,"ACM");
  end
endmodule
